# World War I
# Civilization 4 (c) 2005 Firaxis Games

# Created by -	Jon 'Trip' Shafer
# Have fun!

from CvPythonExtensions import *
import sys
import Popup as PyPopup
from PyHelpers import PyPlayer
import pickle
import CvEventManager
from CvScreenEnums import *
from PyHelpers import *
import CvUtil

# globals
gc = CyGlobalContext()
localText = CyTranslator()

DefaultUnitAI = UnitAITypes.NO_UNITAI
class CvWWIEvents(CvEventManager.CvEventManager):
	
	def __init__(self):
		
		CvEventManager.CvEventManager.__init__(self)
		
		# Number of turns for this scenario
		self.iMaxTurn = 60
		
		# Offset value set in WorldBuilder save
		self.iTurnOffset = 7
		
		self.iJoinCentralPowersThreshold = 400#400
		self.iJoinEntenteThreshold = -400#-400
		
		self.iRevolutionMod = 0#0
		self.iRebelSpawnChance = 10#15
		self.iUnitSpawnRange = 2#2
		self.iCitySpawnUnitCounterMax = 10#6
		
		# The number by which the turn is divided to get the factor to multiply US reinforcements by (turn 60 / 10 = 6)
		self.iUSAReinforcementTurnFactor = 10#15
		self.iUSAGoldAmount = 50#50
		self.iUSAReinforceCounter = 4#6
		self.aiUSAReinforceWaterPlot = [1, 46]
		
		self.iManualBuildUnitChance = 70#70
		
		#############
		
		self.iCentralPowersID =		0
		self.iEntenteID =		1
		
		self.iGermanyID =		0
		self.iAustriaHungaryID =	1
		self.iOttomansID =		2
		self.iRussiaID =		3
		self.iFranceID =		4
		self.iBritainID =		5
		self.iItalyID =	        	6
		self.iUSAID =			7
		self.iSerbiaID =		8
		self.iBulgariaID =		9
		self.iRomaniaID =		10
		self.iBelgiumID =		11
		self.iSpainID =			12
		self.iSwedenID =		13
		self.iGreeceID =		14
		self.iDenmarkID =		15
		self.iNetherlandsID =		16
		self.iPortugalID =		17
		self.iBarbariansID =		18
		self.iNumPlayers =		18
		
		self.szEventText = ""
		self.szResultText = ""
		
	def turnChecker(self, iTurn):
		
		# XXX - Temp for use while debugging/reloading
		self.initValues()
		
		self.szGameDate = CyGameTextMgr().getTimeStr(iTurn, false)
		
		# Check for alignment of various civs to determine if they should declare war on anyone
		self.changeAlignment()
		
		# Check for Revolution
		self.checkForRevolution(iTurn)
		
		# Alter City Unit Spawning Counters
		self.alterCitySpawnUnitCounters()
		
		self.doReinforcements(iTurn)
		
		# Insert all game turn events here
#		return
		
#		print("Turn is: %d" %(iTurn))
		if (iTurn == 7 + self.iTurnOffset):#7
			self.Mar_1915()
		elif (iTurn == 8 + self.iTurnOffset):#8
			self.Apr_1915()
		elif (iTurn == 17 + self.iTurnOffset):#17
			self.Jan_1916()
		elif (iTurn == 31 + self.iTurnOffset):#31
			self.Mar_1917()
		elif (iTurn == 33 + self.iTurnOffset):#33
			self.May_1917()
	
	# Determine the start-game state
	def setupGame(self):
				
		# Temporary Measure to turn off 'Feats'
		CyMessageControl().sendPlayerOption(PlayerOptionTypes.PLAYEROPTION_ADVISOR_POPUPS, false)
		
		self.initValues()
		
		# Used to prevent the AI from acting the same at the start of every game
#		self.randomizeStartingArmies()
		
		for iPlayerLoop in range(self.iNumPlayers):
			
			pPlayer = gc.getPlayer(iPlayerLoop)
			
			# Set default script data manually since we need defaults for all values in array or else we crash:
			# [ iPlayerAlignment | bInRevolution | iNumUnitsLost ]
			aScriptData = [0, false, 0]
			pPlayer.setScriptData(pickle.dumps(aScriptData))
			
			# Set player default commerce to 100% gold since there are no techs
			pPlayer.setCommercePercent(CommerceTypes.COMMERCE_RESEARCH, 70)
			
			# Loop through player's units
#			for iUnitLoop in range(pPlayer.getNumUnits()):
#				
#				self.setUnitDisbandCounter(iPlayerLoop, iUnitLoop, -1)
		
		# Set player default alignments: 400 means war against Entente, -400 means war against Central Powers
		self.setPlayerAlignment(self.iItalyID, -200)
		self.setPlayerAlignment(self.iUSAID, -50)
		self.setPlayerAlignment(self.iBulgariaID, 200)
		self.setPlayerAlignment(self.iRomaniaID, -75)
		self.setPlayerAlignment(self.iGreeceID, -50)
				
	def initValues(self):
		
		self.iCavalryID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_CAVALRY')#83
		self.iBasicLightArtilleryID =		CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_BASIC_LIGHT_ARTILLERY')
		self.iAdvancedLightArtilleryID =	CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_ADVANCED_LIGHT_ARTILLERY')
		self.iMachineGunID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_MACHINE_GUN')
		self.iTankID =				CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_TANK')
		self.iPoisonGasID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_POISON_GAS')
		self.iBiplaneID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_BIPLANE')
		self.iDestroyerID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_DESTROYER')
		self.iDreadnaughtID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_DREADNAUGHT')
		self.iSubmarineID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_SUBMARINE')
		self.iTransportID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_TRANSPORT')
		
		self.iBasicInfantryID =				CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_BASIC_INFANTRY')
		self.iAdvancedInfantryID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_ADVANCED_INFANTRY')
		self.iBasicGermanInfantryID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_BASIC_GERMAN_INFANTRY')
		self.iAdvancedGermanInfantryID =		CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_ADVANCED_GERMAN_INFANTRY')
		self.iBasicAustroHungarianInfantryID =		CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_BASIC_AUSTRO-HUNGARIAN_INFANTRY')
		self.iAdvancedAustroHungarianInfantryID =	CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_ADVANCED_AUSTRO-HUNGARIAN_INFANTRY')
		self.iBasicOttomanInfantryID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_BASIC_OTTOMAN_INFANTRY')
		self.iAdvancedOttomanInfantryID =		CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_ADVANCED_OTTOMAN_INFANTRY')
		self.iBasicRussianInfantryID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_BASIC_RUSSIAN_INFANTRY')
		self.iAdvancedRussianInfantryID =		CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_ADVANCED_RUSSIAN_INFANTRY')
		self.iBasicFrenchInfantryID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_BASIC_FRENCH_INFANTRY')
		self.iAdvancedFrenchInfantryID =		CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_ADVANCED_FRENCH_INFANTRY')
		self.iBasicBritishInfantryID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_BASIC_BRITISH_INFANTRY')
		self.iAdvancedBritishInfantryID =		CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_ADVANCED_BRITISH_INFANTRY')
		self.iBasicItalianInfantryID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_BASIC_ITALIAN_INFANTRY')
		self.iAdvancedItalianInfantryID =		CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_ADVANCED_ITALIAN_INFANTRY')
		self.iBasicAmericanInfantryID =			CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_BASIC_AMERICAN_INFANTRY')
		self.iAdvancedAmericanInfantryID =		CvUtil.findInfoTypeNum(gc.getUnitInfo,gc.getNumUnitInfos(),'WWI_UNIT_ADVANCED_AMERICAN_INFANTRY')
		
		self.iConscriptionCenterID =	CvUtil.findInfoTypeNum(gc.getBuildingInfo,gc.getNumBuildingInfos(),'WWI_BUILDING_CONSCRIPTION_CENTER')#99
		
		self.iMobileAttackDoctrineID =	CvUtil.findInfoTypeNum(gc.getTechInfo,gc.getNumTechInfos(),'WWI_TECH_MOBILE_ATTACK_DOCTRINE')
		self.iArmoredVehiclesID =	CvUtil.findInfoTypeNum(gc.getTechInfo,gc.getNumTechInfos(),'WWI_TECH_ARMORED_VEHICLES')
		
		for iPlayerLoop in range(self.iNumPlayers):
			
			pyPlayer = PyPlayer(iPlayerLoop)
			# Loop through player's cities
			apCityList = pyPlayer.getCityList()
			
			for pCityLoop in apCityList:
				
				# Initialize City
				self.initCity(pCityLoop)
	
###########################################################################################
####################################### MISC EVENTS #######################################
###########################################################################################
			
	def changeAlignment(self):
		
		# Per-turn player alignment change
		self.changePlayerAlignment(self.iItalyID, -10)
		self.changePlayerAlignment(self.iUSAID, -10)
		self.changePlayerAlignment(self.iBulgariaID, 10)
		self.changePlayerAlignment(self.iRomaniaID, -10)
		self.changePlayerAlignment(self.iGreeceID, -10)
		
		iItalyAlignment = self.getPlayerAlignment(self.iItalyID)
		iUSAAlignment = self.getPlayerAlignment(self.iUSAID)
		iBulgariaAlignment = self.getPlayerAlignment(self.iBulgariaID)
		iRomaniaAlignment = self.getPlayerAlignment(self.iRomaniaID)
		iGreeceAlignment = self.getPlayerAlignment(self.iGreeceID)
		
		print("XXX - iItalyAlignment Alignment is %d" %(iItalyAlignment))
		print("XXX - iUSAAlignment Alignment is %d" %(iUSAAlignment))
		print("XXX - iBulgariaAlignment Alignment is %d" %(iBulgariaAlignment))
		print("XXX - iRomaniaAlignment Alignment is %d" %(iRomaniaAlignment))
		print("XXX - iGreeceAlignment Alignment is %d" %(iGreeceAlignment))
		
		aiCivIDs = [self.iItalyID, self.iUSAID, self.iBulgariaID, self.iRomaniaID, self.iGreeceID]
		aiCivAlignments = [iItalyAlignment, iUSAAlignment, iBulgariaAlignment, iRomaniaAlignment, iGreeceAlignment]
		
		# Loop through all these civs
		
		for iPlayerLoop in aiCivIDs:
			
			pPlayer = gc.getPlayer(iPlayerLoop)
			pTeam = gc.getTeam(pPlayer.getTeam())
			
			if (not pPlayer.isHuman()):
				
				iPlayerAlignment = self.getPlayerAlignment(iPlayerLoop)
				bRepeating = true	# This is used so that the American initial unit add event isn't called more than one time
				
				# Declare war on the Entente
				if (iPlayerAlignment >= self.iJoinCentralPowersThreshold):
					
					print("XXX - Player %d has joined the Central Powers!" %(iPlayerLoop))
					
					if (not pTeam.isAtWar(self.iEntenteID)):
#						pTeam.declareWar(self.iEntenteID, false)
						gc.getTeam(self.iCentralPowersID).addTeam(pPlayer.getTeam())
						bRepeating = false
						
				# Declare war on the Central Powers
				elif (iPlayerAlignment <= self.iJoinEntenteThreshold):
					
					print("XXX - Player %d has joined the Entente!" %(iPlayerLoop))
					
					if (not pTeam.isAtWar(self.iCentralPowersID)):
#						pTeam.declareWar(self.iCentralPowersID, false)
						gc.getTeam(self.iEntenteID).addTeam(pPlayer.getTeam())
						bRepeating = false
						
						# Set event text (if applicable)
						if (iPlayerLoop == self.iItalyID):
							self.szEventText = localText.getText("TXT_KEY_WWI_EVENT_ITALY_JOINS_ALLIES_DESC", ())
							self.szResultText = localText.getText("TXT_KEY_WWI_EVENT_ITALY_JOINS_ALLIES_EFFECT", ())
							self.displayEventText()
							
						elif (iPlayerLoop == self.iUSAID):
							self.szEventText = localText.getText("TXT_KEY_WWI_EVENT_USA_JOINS_WAR_DESC", ())
							self.szResultText = localText.getText("TXT_KEY_WWI_EVENT_USA_JOINS_WAR_EFFECT", ())
							self.displayEventText()
				else:
					return
				
				# Need to add a unit to the Americans manually otherwise they don't really 'exist' and aren't technically at war with anyone - which is bad
				if (iPlayerLoop == self.iUSAID and bRepeating == false):
							
					pUSAPlayer = gc.getPlayer(self.iUSAID)
					
					# Determine a plot for the unit to go to, then add them
					
					iWaterPlotRange = 4
					
					aiWaterUnitsPlot = self.findUnitPlacementPlot(self.iUSAID, self.aiUSAReinforceWaterPlot[0], self.aiUSAReinforceWaterPlot[1], false)
					
					if (aiWaterUnitsPlot == "Oh Snap"):
						return
						
					else:
						iX = aiWaterUnitsPlot[0]
						iY = aiWaterUnitsPlot[1]
						
						pUSAPlayer.initUnit(self.iDestroyerID, iX, iY, UnitAITypes.UNITAI_ESCORT_SEA)
						pUSAPlayer.initUnit(self.iDestroyerID, iX, iY, UnitAITypes.UNITAI_ESCORT_SEA)
				
	def checkForRevolution(self, iTurn):
		
		# Factor between 1.0 and 2.0 making revolution more likely
		fRevolutionModifier = iTurn / (self.iMaxTurn * 1.0) * 2
		if (fRevolutionModifier < 1.0):
			fRevolutionModifier = 1.0
		
		# Loop through all players
		for iPlayerLoop in range(self.iNumPlayers):
			
			pPlayer = gc.getPlayer(iPlayerLoop)
			
			print("XXX - Player %d has lost %d Units" %(iPlayerLoop, self.getPlayerNumUnitsLost(iPlayerLoop)))
			
			if (pPlayer.isAlive()):
					
				if (self.isPlayerInRevolution(iPlayerLoop)):
					
					# Player is in Revolution, now make him PAY!
					self.checkForUnitSpawning(iPlayerLoop)
					
					# Okay, we're in Revolution, no need to check any further for this player
					continue
				
				iNumUnitsLost = self.getPlayerNumUnitsLost(iPlayerLoop)
				iTotalPopulation = pPlayer.getTotalPopulation()
				
				# Don't want dead people messing with stuff
				if (iTotalPopulation <= 0):
					return
					
				fRevolutionChance = iNumUnitsLost / (iTotalPopulation * 8.0) * fRevolutionModifier * 100 + self.iRevolutionMod
				iRoll = self.getRand(98) + 1# Measure to prevent a roll of 0
				
				print("XXX - Checking for Player %d revolution with fChance of %f and Rand of %d; %d UnitsLost and Pop of %d" %(iPlayerLoop, fRevolutionChance, iRoll, iNumUnitsLost, iTotalPopulation))
				
				# Check final factor against rand
				if (fRevolutionChance > iRoll):
					
					self.setPlayerInRevolution(iPlayerLoop, true)
					
					# Set event text
					if (iPlayerLoop == self.iRussiaID):
						self.szEventText = localText.getText("TXT_KEY_WWI_EVENT_RUSSIAN_REVOLUTION_DESC", ())
					else:
						self.szEventText = localText.getText("TXT_KEY_WWI_EVENT_GENERIC_REVOLUTION_DESC", ())
						
					self.szResultText = localText.getText("TXT_KEY_WWI_EVENT_GENERIC_REVOLUTION_EFFECT", (pPlayer.getCivilizationShortDescription(0),))
					
					self.displayEventText()
					
	def checkForUnitSpawning(self, iPlayerID):
		
		# Loop through all player cities
		pyPlayer = PyPlayer(iPlayerID)
		apCityList = pyPlayer.getCityList()
		
		for pCityLoop in apCityList:
			iCityID = pCityLoop.getID()
			iCityX = pCityLoop.getX()
			iCityY = pCityLoop.getY()
			
			# If this city has spawned a unit recently then no more units
			if (self.getCitySpawnUnitCounter(iPlayerID, iCityID) == 0):
				
				iUnitSpawnRoll = self.getRand(99)
#				print("iUnitSpawnRoll: %d" %(iUnitSpawnRoll))
				# Create Infantry for the Barbarians
				if (iUnitSpawnRoll < self.iRebelSpawnChance):
					
					aiSpawnPlot = self.findUnitPlacementPlot(self.iBarbariansID, iCityX, iCityY, true, true, self.iUnitSpawnRange)
#					print("Spawn Plot: %d, %d" %(aiSpawnPlot[0], aiSpawnPlot[1]))
					if (aiSpawnPlot == "Oh Snap"):
						return
					else:
						pBarbarians = gc.getPlayer(self.iBarbariansID)
						
						print("XXX - Player %d in revolution; Rebel spawning at [%d, %d]" %(iPlayerID, aiSpawnPlot[0], aiSpawnPlot[1]))
						pBarbarians.initUnit(self.iBasicInfantryID, aiSpawnPlot[0], aiSpawnPlot[1], UnitAITypes.UNITAI_ATTACK)
						
						self.setCitySpawnUnitCounter(iPlayerID, iCityID, self.iCitySpawnUnitCounterMax)
		
	def alterCitySpawnUnitCounters(self):
		
		# Loop through all players' cities
		for iPlayerLoop in range(self.iNumPlayers):
			
			pPlayer = PyPlayer(iPlayerLoop)
			apCityList = pPlayer.getCityList()
			
			for pCity in apCityList:
				
				iCityID = pCity.getID()
				# Reduce CitySpawnUnit counter by 1 in applicable cities
				if (self.getCitySpawnUnitCounter(iPlayerLoop, iCityID) > 0):
					
					self.changeCitySpawnUnitCounter(iPlayerLoop, iCityID, -1)
					
	def doReinforcements(self, iTurn):
		
		pUSATeam = gc.getTeam(gc.getPlayer(self.iUSAID).getTeam())
		
		# USA reinforcements every [self.iUSAReinforceCounter] turns if USA is at war with anyone
		if ((iTurn - self.iTurnOffset) > 0 and (iTurn - self.iTurnOffset) % self.iUSAReinforceCounter == 0):
			if (pUSATeam.isAtWar(self.iCentralPowersID) or pUSATeam.isAtWar(self.iEntenteID)):
				self.addUSAReinforcements(iTurn)
		
		# British free 'Arabian' Cavalry after Ottomans lose 25 units
		if (self.getPlayerNumUnitsLost(self.iOttomansID) >= 25):
			
			pPlayer = gc.getPlayer(self.iBritainID)
			
			# Determine a plot for land units to go to, then add them
			
			iLandPlotRange = 3
			
			aiLandUnitsPlot = self.findUnitPlacementPlot(self.iBritainID, 86, 1, iLandPlotRange)
			
			if (aiLandUnitsPlot == "Oh Snap"):
				return
				
			else:
				iCityX = aiLandUnitsPlot[0]
				iCityY = aiLandUnitsPlot[1]
				
				iUnitIterator = 0
				
				# Spawn units
				for iUnitIterator in range(5):
					pPlayer.initUnit(self.iCavalryID, iCityX, iCityY, DefaultUnitAI)
				
			# Set event text
			self.szEventText = localText.getText("TXT_KEY_WWI_EVENT_ARABIAN_REVOLT_DESC", ())
			self.szResultText = localText.getText("TXT_KEY_WWI_EVENT_ARABIAN_REVOLT_EFFECT", ())
			
			self.displayEventText()
		
	def addUSAReinforcements(self, iTurn):
		
		print("XXX - Adding American reinforcements!")
		
		pUSAPlayer = gc.getPlayer(self.iUSAID)
		
		# Increase coffers (can't be going bankrupt now)
		pUSAPlayer.changeGold(self.iUSAGoldAmount)
		
		# Determine force list based upon what turn it is
		fTurnFactor = iTurn / (self.iUSAReinforcementTurnFactor * 1.0)
		
		iNumCavalry =			int(0.75 * fTurnFactor)
		iNumBasicLightArtillery =	int(0.75 * fTurnFactor)
		iNumBasicAmericanInfantry =	int(2.00 * fTurnFactor)
		iNumMachineGun =		int(0.50 * fTurnFactor)
		
		iNumDestroyer =			int(1.00 * fTurnFactor)
		iNumTransport =			int(((iNumCavalry + iNumBasicLightArtillery + iNumBasicAmericanInfantry + iNumMachineGun) / 4.0) + 1)
		
		# Determine a plot for the units to go to, then add them
		
		iWaterPlotRange = 4
		
		aiWaterUnitsPlot = self.findUnitPlacementPlot(self.iUSAID, self.aiUSAReinforceWaterPlot[0], self.aiUSAReinforceWaterPlot[1], false)
		
		if (aiWaterUnitsPlot == "Oh Snap"):
			return
			
		else:
			iX = aiWaterUnitsPlot[0]
			iY = aiWaterUnitsPlot[1]
			
			for iUnitLoop in range(iNumDestroyer):
				pUSAPlayer.initUnit(self.iDestroyerID, iX, iY, UnitAITypes.UNITAI_ESCORT_SEA)
			for iUnitLoop in range(iNumTransport):
				pUSAPlayer.initUnit(self.iTransportID, iX, iY, UnitAITypes.UNITAI_ASSAULT_SEA)
				
			for iUnitLoop in range(iNumCavalry):
				pUSAPlayer.initUnit(self.iCavalryID, iX, iY, UnitAITypes.UNITAI_ATTACK)
			for iUnitLoop in range(iNumBasicLightArtillery):
				pUSAPlayer.initUnit(self.iBasicLightArtilleryID, iX, iY, UnitAITypes.UNITAI_ATTACK)
			for iUnitLoop in range(iNumBasicAmericanInfantry):
				pUSAPlayer.initUnit(self.iBasicAmericanInfantryID, iX, iY, UnitAITypes.UNITAI_ATTACK)
			for iUnitLoop in range(iNumMachineGun):
				pUSAPlayer.initUnit(self.iMachineGunID, iX, iY, UnitAITypes.UNITAI_ATTACK)
			
		# Set event text
		self.szEventText = localText.getText("TXT_KEY_WWI_EVENT_USA_FORCES_APPEAR_DESC", ())
		self.szResultText = localText.getText("TXT_KEY_WWI_EVENT_USA_FORCES_APPEAR_EFFECT", ())
		
		self.displayEventText()
		
##########################################################################################
####################################### TURN EVENTS #######################################
###########################################################################################
		
	# German unrestricted sub warfare - 3 free subs
	def Mar_1915(self):
		
		aiValidCities = [	self.iBREMEN,
					self.iHAMBURG,
					self.iLUEBECK	]
		
		iCityID = self.determineValidCities(self.iGermanyID, aiValidCities)
		
		# If valid city exists
		if (iCityID > -1):
			
			pPlayer = gc.getPlayer(self.iGermanyID)
			
			iUnitType = self.iSubmarineID

			iCityX = pPlayer.getCity(iCityID).getX()
			iCityY = pPlayer.getCity(iCityID).getY()
			
			# Spawn unit
			pPlayer.initUnit(iUnitType, iCityX, iCityY, UnitAITypes.UNITAI_ATTACK_SEA)
			pPlayer.initUnit(iUnitType, iCityX, iCityY, UnitAITypes.UNITAI_ATTACK_SEA)
			pPlayer.initUnit(iUnitType, iCityX, iCityY, UnitAITypes.UNITAI_ATTACK_SEA)
			
			# Set event text
			self.szEventText = localText.getText("TXT_KEY_WWI_EVENT_UNRESTRICTED_SUBS_DESC", ())
			self.szResultText = localText.getText("TXT_KEY_WWI_EVENT_UNRESTRICTED_SUBS_EFFECT", ())
			
			self.displayEventText()
		
	# British Reinforcements in Egypt and Kuwait
	def Apr_1915(self):
		
		pPlayer = gc.getPlayer(self.iBritainID)
		
		aiValidCities = [	self.iALEXANDRIA,	]
		
		iCityID = self.determineValidCities(self.iBritainID, aiValidCities)
		
		# If valid city exists
		if (iCityID > -1):
			
			iCityX = pPlayer.getCity(iCityID).getX()
			iCityY = pPlayer.getCity(iCityID).getY()
			
			iUnitIterator = 0
			
			# Spawn units
			for iUnitIterator in range(7):
				pPlayer.initUnit(self.iBasicBritishInfantryID, iCityX, iCityY, DefaultUnitAI)
			for iUnitIterator in range(2):
				pPlayer.initUnit(self.iBasicLightArtilleryID, iCityX, iCityY, DefaultUnitAI)
			for iUnitIterator in range(1):
				pPlayer.initUnit(self.iCavalryID, iCityX, iCityY, DefaultUnitAI)
			for iUnitIterator in range(1):
				pPlayer.initUnit(self.iDreadnaughtID, iCityX, iCityY, DefaultUnitAI)
			for iUnitIterator in range(4):
				pPlayer.initUnit(self.iDestroyerID, iCityX, iCityY, DefaultUnitAI)
			for iUnitIterator in range(3):
				pPlayer.initUnit(self.iTransportID, iCityX, iCityY, DefaultUnitAI)
			
		# Determine a plot for land units to go to, then add them
		
		iLandPlotRange = 3
		
		aiLandUnitsPlot = self.findUnitPlacementPlot(self.iBritainID, 99, 2)
		
		if (aiLandUnitsPlot == "Oh Snap"):
			return
			
		else:
			iCityX = aiLandUnitsPlot[0]
			iCityY = aiLandUnitsPlot[1]
			
			iUnitIterator = 0
			
			# Spawn units
			for iUnitIterator in range(5):
				pPlayer.initUnit(self.iBasicBritishInfantryID, iCityX, iCityY, DefaultUnitAI)
			for iUnitIterator in range(1):
				pPlayer.initUnit(self.iBasicLightArtilleryID, iCityX, iCityY, DefaultUnitAI)
			for iUnitIterator in range(1):
				pPlayer.initUnit(self.iCavalryID, iCityX, iCityY, DefaultUnitAI)
			
		# Set event text
		self.szEventText = localText.getText("TXT_KEY_WWI_EVENT_BRITISH_REINFORCE_DESC", ())
		self.szResultText = localText.getText("TXT_KEY_WWI_EVENT_BRITISH_REINFORCE_EFFECT", ())
		
		self.displayEventText()
		
	# British Conscription
	def Jan_1916(self):
		
		pPlayer = PyPlayer(self.iBritainID)
		
		# Add Conscription Centers to all British cities
		apCityList = pPlayer.getCityList()
		for pCity in apCityList:
			
			pCity.setHasRealBuildingIdx(self.iConscriptionCenterID, true)
		
		# Set event text
		self.szEventText = localText.getText("TXT_KEY_WWI_EVENT_BRITISH_CONSCRIPTION_DESC", ())
		self.szResultText = localText.getText("TXT_KEY_WWI_EVENT_BRITISH_CONSCRIPTION_EFFECT", ())
		
		self.displayEventText()
		
	# British Convoy System
	def Mar_1917(self):
		
		aiValidCities = [	self.iLONDON,
					self.iPLYMOUTH,
					self.iHULL	]
		
		iCityID = self.determineValidCities(self.iBritainID, aiValidCities)
		
		# If valid city exists
		if (iCityID > -1):
			
			pPlayer = gc.getPlayer(self.iBritainID)
			
			iUnitType = self.iDestroyerID

			iCityX = pPlayer.getCity(iCityID).getX()
			iCityY = pPlayer.getCity(iCityID).getY()
			
			# Spawn unit
			pPlayer.initUnit(iUnitType, iCityX, iCityY, UnitAITypes.UNITAI_ATTACK_SEA)
			pPlayer.initUnit(iUnitType, iCityX, iCityY, UnitAITypes.UNITAI_ATTACK_SEA)
			pPlayer.initUnit(iUnitType, iCityX, iCityY, UnitAITypes.UNITAI_ATTACK_SEA)
			
			# Set event text
			self.szEventText = localText.getText("TXT_KEY_WWI_EVENT_BRITAIN_CONVOYS_DESC", ())
			self.szResultText = localText.getText("TXT_KEY_WWI_EVENT_BRITAIN_CONVOYS_EFFECT", ())
			
			self.displayEventText()
		
	# French Mutiny - lose HP
	def May_1917(self):
		
		# Loop through all French units and find the Basic Infantry
		pPlayer = PyPlayer(self.iFranceID)
		for pUnit in pPlayer.getUnitList():
			
			if (pUnit.getUnitType() == self.iBasicFrenchInfantryID):
				
				# Add 15-40 damage to each French Basic Infantry
				iDamage = self.getRand(26) + 15
				pUnit.changeDamage(iDamage, self.iGermanyID)
		
		# Set event text
		self.szEventText = localText.getText("TXT_KEY_WWI_EVENT_FRENCH_MUTINY_DESC", ())
		self.szResultText = ""
		
		self.displayEventText()
				
###########################################################################################
#################################### UTILITY FUNCTIONS ####################################
###########################################################################################
		
	def getRand(self, iNum):
		
		return CyGame().getSorenRandNum(iNum, "WWIScenario")
		
	def getScore(self, iPlayerID):
		
		iPopScore = 0
		iVPScore = 0
		iBonusScore = 0
		iUnitScore = 0
		
		# Loop through all players' cities
		pPlayer = PyPlayer(iPlayerID)
		apCityList = pPlayer.getCityList()
		
		for pCity in apCityList:
			
			# Add city all city sizes to score
			iPopScore += pCity.getPopulation()
			
			iCityID = self.getCityIDFromPyPointer(pCity)
			
			# If this is a special city, add more to the score
#			if (iCityID > -1):
#				
#				iVPScore += 20
		
		# Per-player modifiers
		if (iPlayerID == self.iGermanyID):
			iBonusScore += 60
		elif (iPlayerID == self.iAustriaHungaryID):
			iBonusScore += 30
		elif (iPlayerID == self.iOttomansID):
			iBonusScore += 30
			
#		print("Player %d Score: %d, %d, %d, %d" %(iPlayerID, iPopScore, iVPScore, iBonusScore, iUnitScore))
		return (iPopScore + iVPScore + iBonusScore + iUnitScore)
		
	# Override to make the AI build more units than it would normally
	def AI_chooseProduction(self, pCity):
		
#		# Don't manage coastal cities
#		if (pCity.isCoastal):
#			return false
		
		iPlayerID = pCity.getOwner()
		pPlayer = gc.getPlayer(iPlayerID)
		iTeam = pPlayer.getTeam()
		pTeam = gc.getTeam(iTeam)
		
		# These guys need to build a lot of units
		if (iPlayerID == self.iOttomansID or
		    iPlayerID == self.iRussiaID or
		    iPlayerID == self.iAustriaHungaryID):
			
			# Random factor
			iRand = self.getRand(99)
			if (iRand < self.iManualBuildUnitChance):
				
				# Adjust unit to be chosen depending on tech
				if (iPlayerID == self.iAustriaHungaryID):
					if (pTeam.isHasTech(self.iMobileAttackDoctrineID)):
						iUnitTypeNum = self.iAdvancedAustroHungarianInfantryID
					else:
						iUnitTypeNum = self.iBasicAustroHungarianInfantryID
						
				elif (iPlayerID == self.iOttomansID):
					if (pTeam.isHasTech(self.iMobileAttackDoctrineID)):
						iUnitTypeNum = self.iAdvancedOttomanInfantryID
					else:
						iUnitTypeNum = self.iBasicOttomanInfantryID
						
				elif (iPlayerID == self.iRussiaID):
					if (pTeam.isHasTech(self.iMobileAttackDoctrineID)):
						iUnitTypeNum = self.iAdvancedRussianInfantryID
					else:
						iUnitTypeNum = self.iBasicRussianInfantryID
				
#				print("XXX - Pushing order for Ottomans to train Unit type: %d" %(iUnitTypeNum))
				pCity.pushOrder(OrderTypes.ORDER_TRAIN, iUnitTypeNum, -1, False, False, False, True)
				
				return true
		
		# France
		elif (iPlayerID == self.iFranceID):
			
			# Random factor
			iRand = self.getRand(99)
			if (iRand < 50):
				
				# Adjust unit to be chosen depending on tech
				if (pTeam.isHasTech(self.iMobileAttackDoctrineID)):
					iUnitTypeNum = self.iAdvancedFrenchInfantryID
				else:
					iUnitTypeNum = self.iBasicFrenchInfantryID
					
				# Tank Modification!
				if (iRand < 25 and pTeam.isHasTech(self.iArmoredVehiclesID)):
					iUnitTypeNum = self.iTankID
				
				pCity.pushOrder(OrderTypes.ORDER_TRAIN, iUnitTypeNum, -1, False, False, False, True)
				
				return true
		
		# Britain
		elif (iPlayerID == self.iBritainID):
			
			# Coastal cities - Transports and Destroyers
			if (pCity.isCoastal):
				
				# Random factor
				iRand = self.getRand(99)
				# 10% chance of Transport
				if (iRand < 10):
					iUnitTypeNum = self.iTransportID
					pCity.pushOrder(OrderTypes.ORDER_TRAIN, iUnitTypeNum, -1, False, False, False, True)
					return true
					
				# 10% chance of Destroyer
				elif (iRand < 20):
					iUnitTypeNum = self.iDestroyerID
					pCity.pushOrder(OrderTypes.ORDER_TRAIN, iUnitTypeNum, -1, False, False, False, True)
					return true
					
				# 20% chance of Infantry
				elif (iRand < 40):
					
					# Adjust unit to be chosen depending on tech
					if (pTeam.isHasTech(self.iMobileAttackDoctrineID)):
						iUnitTypeNum = self.iAdvancedBritishInfantryID
					else:
						iUnitTypeNum = self.iBasicBritishInfantryID
					
					# Tank Modification!
					if (iRand < 32 and pTeam.isHasTech(self.iArmoredVehiclesID)):
						iUnitTypeNum = self.iTankID
					
					pCity.pushOrder(OrderTypes.ORDER_TRAIN, iUnitTypeNum, -1, False, False, False, True)
					
					return true
		
		# Germany (for Tanks)
		elif (iPlayerID == self.iGermanyID):
			
			# Random factor
			iRand = self.getRand(99)
			if (iRand < 30):
				
				# Tank Modification!
				if (pTeam.isHasTech(self.iArmoredVehiclesID)):
					iUnitTypeNum = self.iTankID
					pCity.pushOrder(OrderTypes.ORDER_TRAIN, iUnitTypeNum, -1, False, False, False, True)
					
					return true
				
		return false
		
#	def getPlayerUnitList(self, iPlayerID):
#		
#		aiUnitList = []
#		
#		if (iPlayerID == self.iGermanyID):
#			aiUnitList.append
		
	def determineValidCities(self, iPlayerID, aiValidCities):
		
		pPlayer = PyPlayer(iPlayerID)
		
		# Loop through Player's cities and see if there are any valid ones
		
		for iValidCity in aiValidCities:
			
			apCityList = pPlayer.getCityList()
			for pCity in apCityList:
				iCityID = pCity.getID()
				
				if (self.getCityIDFromPyPointer(pCity) == iValidCity):
					
					return iCityID
					
		return -1
		
	def findUnitPlacementPlot(self, iPlayerID, iPlotX, iPlotY, bLand = true, bIncludePlot = true, iRange = 3):
		
		aTHEPlot = []
		aiPossiblePlots = []
		iNumPossiblePlots = 0
		aiTempPlotHolder = []
		
		pThisPlayer = gc.getPlayer(iPlayerID)
		pThisTeam = gc.getTeam(pThisPlayer.getTeam())
		
		# Loop through plots in usable range
		for iXLoop in range(iPlotX - iRange, iPlotX + iRange):
			for iYLoop in range(iPlotY - iRange, iPlotY + iRange):
				
				# Map bounds
				if (iXLoop >= 0 and iXLoop < CyMap().getGridWidth() and iYLoop >= 0 and iYLoop < CyMap().getGridHeight()):
					
					# Check to see if center plot should be excluded
					if (bIncludePlot or (not bIncludePlot and (iXLoop != iPlotX) and (iYLoop != iPlotY))):
						
						# Don't include enemy city plots!
						pPlot = CyMap().plot(iXLoop, iYLoop)
						if (pPlot.isEnemyCity(pThisPlayer.getTeam()) == false):
							
							# Check whether plot type is available
							if ((bLand == true and CyMap().plot(iXLoop, iYLoop).isWater() == false) or \
							    (bLand == false and CyMap().plot(iXLoop, iYLoop).isWater() == true)):
								aiTempPlotHolder = [iXLoop, iYLoop]
								aiPossiblePlots.append(aiTempPlotHolder)
								iNumPossiblePlots += 1
					
		if (iNumPossiblePlots == 0):
			return "Oh Snap"
		
		# Now that our list of possible plots is made, we pick one of them randomly and shove aside any enemy units already there
		iChosenPlot = self.getRand(iNumPossiblePlots - 1)
		aTHEPlot = aiPossiblePlots[iChosenPlot]
		
		# Check to see if there are any other units already on this plot
		pPlot = CyMap().plot(aTHEPlot[0], aTHEPlot[1])
		
		if (pPlot.getNumUnits() > 0):
			
			bEnemiesPresent = true
			
			while(pPlot.getNumUnits() > 0 and bEnemiesPresent):
#				print("Test0")
				pLoopUnit = pPlot.getUnit(0)
				pUnitOwner = gc.getPlayer(pLoopUnit.getOwner())
				
				if (pUnitOwner):
					# Check to see if this unit belongs to a player that 'our' player is at war with
					if (pThisTeam.isAtWar(pUnitOwner.getTeam())):
						# Move this enemy unit
						self.moveUnitAside(pLoopUnit)
					else:
						# If it's a friendly, don't move it!
						bEnemiesPresent = false
		
		return aTHEPlot
		
	def moveUnitAside(self, pUnitToMove):
		
		iUnitX = pUnitToMove.getX()
		iUnitY = pUnitToMove.getY()
		
		# Don't look further than 10 plots away
		iMaxRange = 10
		iRing = 1
		
		aaiTestedList = [iUnitX, iUnitY]
		
		pPlayer = gc.getPlayer(pUnitToMove.getOwner())
		pTeam = gc.getTeam(pPlayer.getTeam())
		
		# Loop in rings around the unit's plot until we find another plot to move this unit to
		while (iRing < iMaxRange):
#			print("Test0")
			
			aiTempList = []
			aaiToTestList = []
			iNumToTest = 0
			aaiValidPlotList = []
			iNumValid = 0
			
			# Find plots in this ring range
			for iX in range(-iRing, iRing + 1):
				for iY in range(-iRing, iRing + 1):
					aiTempList = [iX + iUnitX, iY + iUnitY]
					
					# Don't test this plot more than once
					if (aiTempList not in aaiTestedList):
						
						pPlot = CyMap().plot(aiTempList[0], aiTempList[1])
						bValidPlot = false
						
						if (pPlot.isWater() and pUnitToMove.getDomainType() == DomainTypes.DOMAIN_SEA):
							bValidPlot = true
						elif (pPlot.isWater() == false):
							if (pUnitToMove.getDomainType() == DomainTypes.DOMAIN_LAND or pUnitToMove.getDomainType() == DomainTypes.DOMAIN_AIR):
								bValidPlot = true
						
						# Make sure this unit can move to this plot type (no land units on water, etc.)
						if (bValidPlot):
							aaiToTestList.append(aiTempList)
							iNumToTest += 1
					
			# Now test these plots
			for iTestLoop in range(iNumToTest):
				
				pPlot = CyMap().plot(iUnitX, iUnitY)
				
				iX = aaiToTestList[iTestLoop][0]
				iY = aaiToTestList[iTestLoop][1]
				
				# If there are no enemy units here then add to the final valid plot list
				if (not self.isEnemyUnits(pTeam, iX, iY)):
					
					aaiValidPlotList.append(aaiToTestList[iTestLoop])
					iNumValid += 1
					
				# Add this plot to the tested list (to prevent it being looked at again) and look at the next in this ring
				aaiTestedList.append(aaiToTestList[iTestLoop])
				
			# This ring has been iterated through and placed in a final list - now pick a random plot from that list and exit the function
			
			if (iNumValid > 0):
#				print(aaiValidPlotList)
				iChosenPlot = self.getRand(iNumValid - 1)
				
				iX = aaiValidPlotList[iChosenPlot][0]
				iY = aaiValidPlotList[iChosenPlot][1]
				
				pUnitToMove.setXY(iX, iY)
				
				return
				
			# None of the plots in this ring are valid, so time to try the next ring
			
			iRing += 1
		
	def isEnemyUnits(self, pThisTeam, iPlotX, iPlotY):
		
		# Check to see if there are any other units already on this plot
		pPlot = CyMap().plot(iPlotX, iPlotY)
		
		if (pPlot.getNumUnits() > 0):
			
			for iUnitLoop in range(pPlot.getNumUnits()):
				
				pLoopUnit = pPlot.getUnit(iUnitLoop)
				
				pUnitOwner = gc.getPlayer(pLoopUnit.getOwner())
				
				# Check to see if this unit belongs to a player that 'our' player is at war with
				if (pThisTeam.isAtWar(pUnitOwner.getTeam())):
					return true
		
		return false
		
###### CITY SCRIPT DATA ######
		
	def getCityID(self, iPlayer, iCity):
		
		pPlayer = gc.getPlayer(iPlayer)
		pCity = pPlayer.getCity(iCity)
		
		# Load Script Data - CityID
		szScriptData = pickle.loads(pCity.getScriptData())
		iCityID = szScriptData[0]
		
		return iCityID
		
	def setCityID(self, iPlayer, iCity, iValue):
		
		pPlayer = gc.getPlayer(iPlayer)
		pCity = pPlayer.getCity(iCity)
		
		# Load Script Data - City ID
		szScriptData = pickle.loads(pCity.getScriptData())
		iSpawnUnitCounter = szScriptData[1]
		
		# Save Script Data - City ID
		szScriptData = [iValue, iSpawnUnitCounter]
		pCity.setScriptData(pickle.dumps(szScriptData))
	
	def getCityIDFromPyPointer(self, pCity):
		
		# Load Script Data - CityID
		szScriptData = pickle.loads(pCity.getScriptData())
		iCityID = szScriptData[0]
		
		return iCityID
		
	def getCitySpawnUnitCounter(self, iPlayer, iCity):
		
		pPlayer = gc.getPlayer(iPlayer)
		pCity = pPlayer.getCity(iCity)
		
		# Load Script Data - SpawnUnitCounter
		szScriptData = pickle.loads(pCity.getScriptData())
		iSpawnUnitCounter = szScriptData[1]
		
		return iSpawnUnitCounter
		
	def setCitySpawnUnitCounter(self, iPlayer, iCity, iValue):
		
		pPlayer = gc.getPlayer(iPlayer)
		pCity = pPlayer.getCity(iCity)
		
		# Load Script Data - SpawnUnitCounter
		szScriptData = pickle.loads(pCity.getScriptData())
		iCityID = szScriptData[0]
		
		# Save Script Data - SpawnUnitCounter
		szScriptData = [iCityID, iValue]
		pCity.setScriptData(pickle.dumps(szScriptData))
		
	def changeCitySpawnUnitCounter(self, iPlayer, iCity, iChange):
		
		pPlayer = gc.getPlayer(iPlayer)
		pCity = pPlayer.getCity(iCity)
		
		# Load Script Data - SpawnUnitCounter
		szScriptData = pickle.loads(pCity.getScriptData())
		iCityID = szScriptData[0]
		iSpawnUnitCounter = szScriptData[1]
		
		iSpawnUnitCounter += iChange
		
		# Save Script Data - SpawnUnitCounter
		szScriptData = [iCityID, iSpawnUnitCounter]
		pCity.setScriptData(pickle.dumps(szScriptData))
		
###### PLAYER SCRIPT DATA ######
		
	def getPlayerAlignment(self, iPlayer):
		
		pPlayer = gc.getPlayer(iPlayer)
		
		# Load Script Data - Alignment
		szScriptData = pickle.loads(pPlayer.getScriptData())
		iAlignment = szScriptData[0]
		
		return iAlignment
		
	def setPlayerAlignment(self, iPlayer, iValue):
		
		pPlayer = gc.getPlayer(iPlayer)
		
		# Load Script Data - Alignment
		szScriptData = pickle.loads(pPlayer.getScriptData())
		
		# Save Script Data - Alignment
		szScriptData[0] = iValue
		pPlayer.setScriptData(pickle.dumps(szScriptData))
		
	def changePlayerAlignment(self, iPlayer, iChange):
		
		pPlayer = gc.getPlayer(iPlayer)
		
		# Load Script Data - Alignment
		szScriptData = pickle.loads(pPlayer.getScriptData())
		iAlignment = szScriptData[0]
		
		iAlignment += iChange
		
		# Save Script Data - Alignment
		szScriptData[0] = iAlignment
		pPlayer.setScriptData(pickle.dumps(szScriptData))
		
	def isPlayerInRevolution(self, iPlayer):
		
		pPlayer = gc.getPlayer(iPlayer)
		
		# Load Script Data - Revolution
		szScriptData = pickle.loads(pPlayer.getScriptData())
		bInRevolution = szScriptData[1]
		
		return bInRevolution
		
	def setPlayerInRevolution(self, iPlayer, bValue):
		
		pPlayer = gc.getPlayer(iPlayer)
		
		# Load Script Data - Revolution
		szScriptData = pickle.loads(pPlayer.getScriptData())
		
		# Save Script Data - Revolution
		szScriptData[1] = bValue
		pPlayer.setScriptData(pickle.dumps(szScriptData))
		
	def getPlayerNumUnitsLost(self, iPlayer):
		
		pPlayer = gc.getPlayer(iPlayer)
		
		# Load Script Data - Num Units Lost
		szScriptData = pickle.loads(pPlayer.getScriptData())
		iNumUnitsLost = szScriptData[2]
		
		return iNumUnitsLost
		
	def setPlayerNumUnitsLost(self, iPlayer, iValue):
		
		pPlayer = gc.getPlayer(iPlayer)
		
		# Load Script Data - Num Units Lost
		szScriptData = pickle.loads(pPlayer.getScriptData())
		
		# Save Script Data - Num Units Lost
		szScriptData[2] = iValue
		pPlayer.setScriptData(pickle.dumps(szScriptData))
		
	def changePlayerNumUnitsLost(self, iPlayer, iChange):
		
		pPlayer = gc.getPlayer(iPlayer)
		#print("XXX - changing PlayerNumUnitsLost; Player %d Script Data: %s, Changing to %d" %(iPlayer, pPlayer.getScriptData(), iChange))
		# Load Script Data - Num Units Lost
		szScriptData = pickle.loads(pPlayer.getScriptData())
		iNumUnitsLost = szScriptData[2]
		
		iNumUnitsLost += iChange
		
		# Save Script Data - Num Units Lost
		szScriptData[2] = iNumUnitsLost
		pPlayer.setScriptData(pickle.dumps(szScriptData))
		
	### EVENTS ###
		
	def displayEventText(self):
		
		if (gc.getPlayer(CyGame().getActivePlayer()).isAlive()):
			
			szTitle = self.szGameDate = CyGameTextMgr().getTimeStr(CyGame().getGameTurn(), false)
			
			popup = PyPopup.PyPopup(-1)
			popup.setHeaderString(szTitle)
			popup.setBodyString(self.szEventText + "\n\n" + self.szResultText)
			popup.launch(true, PopupStates.POPUPSTATE_QUEUED)
		
	def addPopup(self, szText):
		
		szTitle = self.szGameDate = CyGameTextMgr().getTimeStr(CyGame().getGameTurn(), false)
		
		popup = PyPopup.PyPopup(-1)
		popup.setHeaderString(szTitle)
		popup.setBodyString(szText)
		popup.launch(true, PopupStates.POPUPSTATE_QUEUED)
		
###########################################################################################
##################################### EVENT OVERRIDES #####################################
###########################################################################################
	
	def onLoadGame(self, argsList):
		'Called when game is loaded'
		
		self.initValues()
	
	def onGameStart(self, argsList):
		'Called at the start of the game'
		
		self.setupGame()
		
		for iPlayer in range(gc.getMAX_PLAYERS()):
			player = gc.getPlayer(iPlayer)
			if (player.isAlive() and player.isHuman()):
				popupInfo = CyPopupInfo()
				popupInfo.setButtonPopupType(ButtonPopupTypes.BUTTONPOPUP_PYTHON_SCREEN)
				popupInfo.setText(u"showDawnOfMan")
				popupInfo.addPopup(iPlayer)
		
	def onBeginGameTurn(self, argsList):
		'Called at the beginning of the end of each turn'
		iGameTurn = argsList[0]
		
		gc.getTeam(self.iCentralPowersID).declareWar(self.iEntenteID, 0)
		
		# World War I events
		self.turnChecker(iGameTurn)
		
	def onChangeWar(self, argsList):
		'War Status Changes'
		bIsWar = argsList[0]
		iTeam = argsList[1]
		iRivalTeam = argsList[2]
		if (bIsWar):
			strStatus = "declared war"
		else:
			strStatus = "declared peace"
		CvUtil.pyPrint('Team %d has %s on Team %d'
			%(iTeam, strStatus, iRivalTeam))
		
		# FIX THIS...
		# Add Italy to the Entente or Central Powers if its a human player
		#if (iTeam == gc.getPlayer(self.iItalyID).getTeam() and gc.getTeam(iTeam).isHuman()):
			
			# Declared war on Central Powers, join Entente
			#if (iRivalTeam == self.iCentralPowersID):
				#gc.getTeam(self.iEntenteID).addTeam(iTeam)
			#elif (iRivalTeam == self.iEntenteID):
				#gc.getTeam(self.iCentralPowersID).addTeam(iTeam)
		
	def onUnitLost(self, argsList):
		'Unit Lost'
		
		unit = argsList[0]
		player = PyPlayer(unit.getOwner())
		CvUtil.pyPrint('%s was lost by Player %d Civilization %s' 
			%(PyInfo.UnitInfo(unit.getUnitType()).getDescription(), player.getID(), player.getCivilizationName()))
		
		if (not player.isBarbarian()):
			self.changePlayerNumUnitsLost(player.getID(), 1)
		
		iTeam = gc.getPlayer(unit.getOwner()).getTeam()
		
		# Civs whose alignment CHANGES when the CENTRAL POWERS lose units
		if (iTeam == self.iCentralPowersID):
			
			self.changePlayerAlignment(self.iItalyID, 1)
			self.changePlayerAlignment(self.iUSAID, -1)
			self.changePlayerAlignment(self.iBulgariaID, -1)
			self.changePlayerAlignment(self.iRomaniaID, 1)
			self.changePlayerAlignment(self.iGreeceID, 1)
		
		# Civs whose alignment CHANGES when the ALLIES lose units
		if (iTeam == self.iEntenteID):
			
			self.changePlayerAlignment(self.iItalyID, -1)
			self.changePlayerAlignment(self.iUSAID, 1)
			self.changePlayerAlignment(self.iBulgariaID, 1)
			self.changePlayerAlignment(self.iRomaniaID, -1)
			self.changePlayerAlignment(self.iGreeceID, -1)
			
	def onCityAcquired(self, argsList):
		'City Acquired'
		
		owner,playerType,city,bConquest,bTrade = argsList
		CvUtil.pyPrint('City Acquired Event: %s' %(city.getName()))
		
		self.initCity(city)
		
	# Putting this guy at the bottom because he's so huge
	def initCity(self, pCity):
		
		# This stuff is used to generate the city list seen just below:
		
#		print("Generating cool stuff")
#		iCityNum = 0
#		for iPlayerLoop in range(self.iNumPlayers):
#			pPlayer = gc.getPlayer(iPlayerLoop)
#			for iCityLoop in range(pPlayer.getNumCities()):
#				pCity = pPlayer.getCity(iCityLoop)
#				print("\t\tif (aiCityXY == [%d, %d]):\n\t\t\tself.i%s = iCityCount = %d" %(pCity.getX(), pCity.getY(), pCity.getName().upper(), iCityNum))
#				iCityNum += 1
		
		aiCityXY = [pCity.getX(), pCity.getY()]
		
		# This will become the city "ID" within the scenario used to identify it later (in case it's renamed or something)
		iCityCount = 0
		
		iCitySpawnUnitCounterDefault = 0
		
		if (aiCityXY == [35, 43]):
			self.iSTRASSBURG = iCityCount = 0
		if (aiCityXY == [36, 47]):
			self.iCOLOGNE = iCityCount = 1
		if (aiCityXY == [37, 53]):
			self.iBREMEN = iCityCount = 2
		if (aiCityXY == [38, 43]):
			self.iSTUTTGART = iCityCount = 3
		if (aiCityXY == [39, 50]):
			self.iHANOVER = iCityCount = 4
		if (aiCityXY == [40, 54]):
			self.iHAMBURG = iCityCount = 5
		if (aiCityXY == [41, 43]):
			self.iMUNICH = iCityCount = 6
		if (aiCityXY == [41, 47]):
			self.iLEIPZIG = iCityCount = 7
		if (aiCityXY == [44, 49]):
			self.iBERLIN = iCityCount = 8
		if (aiCityXY == [44, 53]):
			self.iLUEBECK = iCityCount = 9
		if (aiCityXY == [47, 49]):
			self.iPOSEN = iCityCount = 10
		if (aiCityXY == [48, 46]):
			self.iBRESLAU = iCityCount = 11
		if (aiCityXY == [48, 53]):
			self.iSTETTIN = iCityCount = 12
		if (aiCityXY == [53, 53]):
			self.iKONIGSBERG = iCityCount = 13
		if (aiCityXY == [54, 56]):
			self.iMEMEL = iCityCount = 14
		if (aiCityXY == [42, 39]):
			self.iSALZBURG = iCityCount = 15
		if (aiCityXY == [43, 35]):
			self.iTRIESTE = iCityCount = 16
		if (aiCityXY == [45, 31]):
			self.iFIUME = iCityCount = 17
		if (aiCityXY == [45, 44]):
			self.iPRAGUE = iCityCount = 18
		if (aiCityXY == [46, 36]):
			self.iGRAZ = iCityCount = 19
		if (aiCityXY == [46, 40]):
			self.iVIENNA = iCityCount = 20
		if (aiCityXY == [48, 28]):
			self.iRAGUSA = iCityCount = 21
		if (aiCityXY == [49, 31]):
			self.iSARAJEVO = iCityCount = 22
		if (aiCityXY == [49, 34]):
			self.iZAGREB = iCityCount = 23
		if (aiCityXY == [49, 42]):
			self.iPRESSBURG = iCityCount = 24
		if (aiCityXY == [50, 38]):
			self.iBUDAPEST = iCityCount = 25
		if (aiCityXY == [53, 44]):
			self.iKRAKOW = iCityCount = 26
		if (aiCityXY == [54, 34]):
			self.iTEMESVAR = iCityCount = 27
		if (aiCityXY == [54, 37]):
			self.iNAGYVARAD = iCityCount = 28
		if (aiCityXY == [54, 41]):
			self.iKOSICE = iCityCount = 29
		if (aiCityXY == [58, 39]):
			self.iRUTHENIA = iCityCount = 30
		if (aiCityXY == [58, 43]):
			self.iLEMBERG = iCityCount = 31
		if (aiCityXY == [59, 35]):
			self.iTRANSYLVANIA = iCityCount = 32
		if (aiCityXY == [61, 41]):
			self.iTARNOPOL = iCityCount = 33
		if (aiCityXY == [62, 18]):
			self.iSMYRNA = iCityCount = 34
		if (aiCityXY == [62, 23]):
			self.iGALLIPOLI = iCityCount = 35
		if (aiCityXY == [65, 25]):
			self.iCONSTANTINOPLE = iCityCount = 36
		if (aiCityXY == [66, 22]):
			self.iBURSA = iCityCount = 37
		if (aiCityXY == [69, 16]):
			self.iANATALYA = iCityCount = 38
		if (aiCityXY == [70, 19]):
			self.iKONYA = iCityCount = 39
		if (aiCityXY == [72, 22]):
			self.iANGORA = iCityCount = 40
		if (aiCityXY == [73, 26]):
			self.iSINOPE = iCityCount = 41
		if (aiCityXY == [75, 4]):
			self.iGAZA = iCityCount = 42
		if (aiCityXY == [75, 16]):
			self.iADANA = iCityCount = 43
		if (aiCityXY == [77, 26]):
			self.iSAMSUN = iCityCount = 44
		if (aiCityXY == [78, 6]):
			self.iJERUSALEM = iCityCount = 45
		if (aiCityXY == [79, 10]):
			self.iDAMASCUS = iCityCount = 46
		if (aiCityXY == [79, 20]):
			self.iSIVAS = iCityCount = 47
		if (aiCityXY == [81, 14]):
			self.iALEPPO = iCityCount = 48
		if (aiCityXY == [81, 26]):
			self.iTRABZON = iCityCount = 49
		if (aiCityXY == [85, 23]):
			self.iERZERUM = iCityCount = 50
		if (aiCityXY == [89, 17]):
			self.iMOSUL = iCityCount = 51
		if (aiCityXY == [94, 13]):
			self.iBAGHDAD = iCityCount = 52
		if (aiCityXY == [99, 10]):
			self.iBASRA = iCityCount = 53
		if (aiCityXY == [50, 49]):
			self.iLODZ = iCityCount = 54
		if (aiCityXY == [54, 48]):
			self.iWARSAW = iCityCount = 55
		if (aiCityXY == [57, 58]):
			self.iRIGA = iCityCount = 56
		if (aiCityXY == [58, 54]):
			self.iVILNIUS = iCityCount = 57
		if (aiCityXY == [58, 65]):
			self.iHELSINKI = iCityCount = 58
		if (aiCityXY == [59, 47]):
			self.iBRESTLITOVSK = iCityCount = 59
		if (aiCityXY == [59, 63]):
			self.iTALLINN = iCityCount = 60
		if (aiCityXY == [63, 51]):
			self.iMINSK = iCityCount = 61
		if (aiCityXY == [63, 65]):
			self.iSTPETERSBURG = iCityCount = 62
		if (aiCityXY == [64, 47]):
			self.iPINSK = iCityCount = 63
		if (aiCityXY == [66, 60]):
			self.iNOVGOROD = iCityCount = 64
		if (aiCityXY == [67, 36]):
			self.iODESSA = iCityCount = 65
		if (aiCityXY == [69, 42]):
			self.iKIEV = iCityCount = 66
		if (aiCityXY == [71, 50]):
			self.iSMOLENSK = iCityCount = 67
		if (aiCityXY == [72, 34]):
			self.iSEVASTOPOL = iCityCount = 68
		if (aiCityXY == [77, 44]):
			self.iKHARKOV = iCityCount = 69
		if (aiCityXY == [78, 39]):
			self.iROSTOV = iCityCount = 70
		if (aiCityXY == [78, 54]):
			self.iMOSCOW = iCityCount = 71
		if (aiCityXY == [85, 29]):
			self.iBATUMI = iCityCount = 72
		if (aiCityXY == [85, 45]):
			self.iTSARITSYN = iCityCount = 73
		if (aiCityXY == [86, 59]):
			self.iKAZAN = iCityCount = 74
		if (aiCityXY == [87, 51]):
			self.iSARATOV = iCityCount = 75
		if (aiCityXY == [88, 55]):
			self.iSAMARA = iCityCount = 76
		if (aiCityXY == [91, 30]):
			self.iTIFLIS = iCityCount = 77
		if (aiCityXY == [92, 41]):
			self.iASTRAKHAN = iCityCount = 78
		if (aiCityXY == [96, 60]):
			self.iPERM = iCityCount = 79
		if (aiCityXY == [98, 30]):
			self.iBAKU = iCityCount = 80
		if (aiCityXY == [3, 20]):
			self.iCASABLANCA = iCityCount = 81
		if (aiCityXY == [8, 19]):
			self.iFEZ = iCityCount = 82
		if (aiCityXY == [17, 20]):
			self.iORAN = iCityCount = 83
		if (aiCityXY == [19, 48]):
			self.iBREST = iCityCount = 84
		if (aiCityXY == [21, 39]):
			self.iBORDEAUX = iCityCount = 85
		if (aiCityXY == [21, 44]):
			self.iNANTES = iCityCount = 86
		if (aiCityXY == [22, 20]):
			self.iALGIERS = iCityCount = 87
		if (aiCityXY == [25, 36]):
			self.iTOULOUSE = iCityCount = 88
		if (aiCityXY == [26, 43]):
			self.iORLEANS = iCityCount = 89
		if (aiCityXY == [26, 48]):
			self.iCAEN = iCityCount = 90
		if (aiCityXY == [29, 33]):
			self.iMARSEILLES = iCityCount = 91
		if (aiCityXY == [29, 45]):
			self.iPARIS = iCityCount = 92
		if (aiCityXY == [29, 50]):
			self.iCALAIS = iCityCount = 93
		if (aiCityXY == [30, 38]):
			self.iLYON = iCityCount = 94
		if (aiCityXY == [31, 42]):
			self.iNANCY = iCityCount = 95
		if (aiCityXY == [32, 46]):
			self.iREIMS = iCityCount = 96
		if (aiCityXY == [34, 16]):
			self.iTUNIS = iCityCount = 97
		if (aiCityXY == [34, 28]):
			self.iAJACCIO = iCityCount = 98
		if (aiCityXY == [8, 25]):
			self.iGIBRALTAR = iCityCount = 99
		if (aiCityXY == [20, 58]):
			self.iDUBLIN = iCityCount = 100
		if (aiCityXY == [21, 52]):
			self.iPLYMOUTH = iCityCount = 101
		if (aiCityXY == [22, 61]):
			self.iBELFAST = iCityCount = 102
		if (aiCityXY == [24, 54]):
			self.iBRISTOL = iCityCount = 103
		if (aiCityXY == [24, 57]):
			self.iMANCHESTER = iCityCount = 104
		if (aiCityXY == [27, 52]):
			self.iLONDON = iCityCount = 105
		if (aiCityXY == [27, 61]):
			self.iEDINBURGH = iCityCount = 106
		if (aiCityXY == [27, 64]):
			self.iDUNDEE = iCityCount = 107
		if (aiCityXY == [28, 57]):
			self.iHULL = iCityCount = 108
		if (aiCityXY == [69, 4]):
			self.iALEXANDRIA = iCityCount = 109
		if (aiCityXY == [70, 1]):
			self.iCAIRO = iCityCount = 110
		if (aiCityXY == [73, 12]):
			self.iNIKOSIA = iCityCount = 111
		if (aiCityXY == [33, 23]):
			self.iCAGLIARI = iCityCount = 112
		if (aiCityXY == [36, 8]):
			self.iTRIPOLI = iCityCount = 113
		if (aiCityXY == [36, 36]):
			self.iMILAN = iCityCount = 114
		if (aiCityXY == [39, 27]):
			self.iROME = iCityCount = 115
		if (aiCityXY == [39, 31]):
			self.iFLORENCE = iCityCount = 116
		if (aiCityXY == [40, 19]):
			self.iPALERMO = iCityCount = 117
		if (aiCityXY == [40, 35]):
			self.iVENETO = iCityCount = 118
		if (aiCityXY == [43, 24]):
			self.iNAPLES = iCityCount = 119
		if (aiCityXY == [44, 19]):
			self.iREGGIO = iCityCount = 120
		if (aiCityXY == [47, 24]):
			self.iBARI = iCityCount = 121
		if (aiCityXY == [51, 5]):
			self.iBENGHAZI = iCityCount = 122
		if (aiCityXY == [53, 25]):
			self.iSKOPLJE = iCityCount = 123
		if (aiCityXY == [53, 28]):
			self.iNISH = iCityCount = 124
		if (aiCityXY == [53, 31]):
			self.iBELGRADE = iCityCount = 125
		if (aiCityXY == [57, 27]):
			self.iSOFIA = iCityCount = 126
		if (aiCityXY == [58, 24]):
			self.iPHILIPPOPOLIS = iCityCount = 127
		if (aiCityXY == [62, 28]):
			self.iBURGAS = iCityCount = 128
		if (aiCityXY == [59, 30]):
			self.iBUCHAREST = iCityCount = 129
		if (aiCityXY == [63, 37]):
			self.iJASSY = iCityCount = 130
		if (aiCityXY == [64, 31]):
			self.iCONSTANTSA = iCityCount = 131
		if (aiCityXY == [64, 34]):
			self.iGALATZ = iCityCount = 132
		if (aiCityXY == [33, 49]):
			self.iBRUSSELS = iCityCount = 133
		if (aiCityXY == [7, 23]):
			self.iTANGIER = iCityCount = 134
		if (aiCityXY == [10, 28]):
			self.iSEVILLE = iCityCount = 135
		if (aiCityXY == [10, 31]):
			self.iMERIDA = iCityCount = 136
		if (aiCityXY == [10, 39]):
			self.iSANTIAGO = iCityCount = 137
		if (aiCityXY == [12, 35]):
			self.iSALAMANCA = iCityCount = 138
		if (aiCityXY == [14, 26]):
			self.iGRANADA = iCityCount = 139
		if (aiCityXY == [14, 32]):
			self.iMADRID = iCityCount = 140
		if (aiCityXY == [16, 37]):
			self.iBILBAO = iCityCount = 141
		if (aiCityXY == [18, 28]):
			self.iMURCIA = iCityCount = 142
		if (aiCityXY == [19, 33]):
			self.iZARAGOZA = iCityCount = 143
		if (aiCityXY == [23, 31]):
			self.iBARCELONA = iCityCount = 144
		if (aiCityXY == [38, 64]):
			self.iSTAVANGER = iCityCount = 145
		if (aiCityXY == [40, 72]):
			self.iTRONDHEIM = iCityCount = 146
		if (aiCityXY == [43, 64]):
			self.iCHRISTIANIA = iCityCount = 147
		if (aiCityXY == [44, 60]):
			self.iGOTEBORG = iCityCount = 148
		if (aiCityXY == [45, 56]):
			self.iMALMO = iCityCount = 149
		if (aiCityXY == [48, 60]):
			self.iKALMAR = iCityCount = 150
		if (aiCityXY == [50, 64]):
			self.iSTOCKHOLM = iCityCount = 151
		if (aiCityXY == [50, 67]):
			self.iUPPSALA = iCityCount = 152
		if (aiCityXY == [53, 19]):
			self.iYANNINA = iCityCount = 153
		if (aiCityXY == [55, 15]):
			self.iSPARTA = iCityCount = 154
		if (aiCityXY == [55, 22]):
			self.iSALONIKA = iCityCount = 155
		if (aiCityXY == [57, 18]):
			self.iATHENS = iCityCount = 156
		if (aiCityXY == [58, 12]):
			self.iCANDIA = iCityCount = 157
		if (aiCityXY == [39, 59]):
			self.iVIBORG = iCityCount = 158
		if (aiCityXY == [42, 57]):
			self.iCOPENHAGEN = iCityCount = 159
		if (aiCityXY == [34, 52]):
			self.iAMSTERDAM = iCityCount = 160
		if (aiCityXY == [5, 29]):
			self.iFARO = iCityCount = 161
		if (aiCityXY == [6, 33]):
			self.iLISBON = iCityCount = 162
		if (aiCityXY == [8, 36]):
			self.iOPORTO = iCityCount = 163
			
		# Set default script data manually since we need defaults for all values in array
		aScriptData = [iCityCount, iCitySpawnUnitCounterDefault]
		pCity.setScriptData(pickle.dumps(aScriptData))
